-- Create database (optional if you already have one)
CREATE DATABASE IF NOT EXISTS compnet_shop
    CHARACTER SET utf8mb4
    COLLATE utf8mb4_unicode_ci;

USE compnet_shop;

-- CATEGORIES
CREATE TABLE IF NOT EXISTS categories (
        id INT UNSIGNED AUTO_INCREMENT PRIMARY KEY,
        name VARCHAR(150) NOT NULL,
        slug VARCHAR(150) NOT NULL UNIQUE,
        created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

-- PRODUCTS
CREATE TABLE IF NOT EXISTS products (
        id INT UNSIGNED AUTO_INCREMENT PRIMARY KEY,
        name VARCHAR(255) NOT NULL,
        slug VARCHAR(255) DEFAULT NULL,
        category_id INT UNSIGNED NOT NULL,
        price DECIMAL(10,2) NOT NULL,
        old_price DECIMAL(10,2) DEFAULT NULL,
        short_meta VARCHAR(255) DEFAULT NULL,
        description TEXT DEFAULT NULL,
        main_image VARCHAR(255) DEFAULT NULL,
        tags VARCHAR(255) DEFAULT NULL,
        `condition` VARCHAR(50) DEFAULT NULL,        -- new, ex-uk, refurb, used
        stock INT DEFAULT 0,
        is_featured TINYINT(1) NOT NULL DEFAULT 0,
        is_active TINYINT(1) NOT NULL DEFAULT 1,
        created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
        CONSTRAINT fk_products_category
                FOREIGN KEY (category_id) REFERENCES categories(id)
                ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

-- ORDERS
CREATE TABLE IF NOT EXISTS orders (
        id INT UNSIGNED AUTO_INCREMENT PRIMARY KEY,
        customer_name VARCHAR(150) NOT NULL,
        phone VARCHAR(50) NOT NULL,
        email VARCHAR(150) DEFAULT NULL,
        town VARCHAR(100) DEFAULT NULL,
        address TEXT NOT NULL,
        notes TEXT DEFAULT NULL,
        total_amount DECIMAL(10,2) NOT NULL DEFAULT 0,
        status VARCHAR(50) NOT NULL DEFAULT 'pending',        -- pending, confirmed, shipped, completed, cancelled
        payment_status VARCHAR(50) NOT NULL DEFAULT 'unpaid', -- unpaid, paid_mpesa, paid_cash, refunded
        payment_reference VARCHAR(100) DEFAULT NULL,          -- MPESA or other ref
        paid_at DATETIME DEFAULT NULL,
        created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

-- ORDER ITEMS
CREATE TABLE IF NOT EXISTS order_items (
        id INT UNSIGNED AUTO_INCREMENT PRIMARY KEY,
        order_id INT UNSIGNED NOT NULL,
        product_id INT UNSIGNED NOT NULL,
        product_name VARCHAR(255) NOT NULL,
        unit_price DECIMAL(10,2) NOT NULL,
        quantity INT UNSIGNED NOT NULL,
        line_total DECIMAL(10,2) NOT NULL,
        CONSTRAINT fk_order_items_order
                FOREIGN KEY (order_id) REFERENCES orders(id)
                ON DELETE CASCADE,
        CONSTRAINT fk_order_items_product
                FOREIGN KEY (product_id) REFERENCES products(id)
                ON DELETE RESTRICT
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

-- SEED MAIN CATEGORIES
INSERT INTO categories (name, slug) VALUES
('Laptops', 'laptops'),
('Accessories', 'accessories'),
('Networking', 'networking')
ON DUPLICATE KEY UPDATE name = VALUES(name);
